package com.example.blas.myapplication.clases;
import android.database.Cursor;
import android.database.sqlite.*;
import android.content.*;

import com.example.blas.myapplication.clases.conexionDB;

/**
 * Created by blas on 21/01/18.
 */
public class tablaDB  extends conexionDB {
    private static String   TABLA_NOMBRE   =  "";
    private static String   COLUMNA_ID      =  "_id";
    private static String[] COLUMNAS        = null;
    private static Cursor   cursor          = null;
    private static Cursor   Index           = null;

    private String getCOLUMNA_ID() {
        return COLUMNA_ID;
    }
    private void setCOLUMNA_ID(String t) {
        COLUMNA_ID = t;
    }

    public String getTABLA_NOMBRE() {
        return TABLA_NOMBRE;
    }
    public void setTABLA_NOMBRE(String t) {
        TABLA_NOMBRE = t;
    }
    public String[] getCOLUMNAS() {
        return COLUMNAS;
    }
    public void setCOLUMNAS(String[] c) {
        COLUMNAS = c;
    }

    //----------------------------------------
    public int getID(){
        return Index.getInt(0);
    }
    public tablaDB(Context context) {
        super(context);
    }
    public Boolean dataAbrir(){
        if(this.setIndex())
            this.dataObtener();

        return true;
    }

    //======================================
        public int dataAgregar(ContentValues v){
            SQLiteDatabase db = this.getWritableDatabase();
            ContentValues values = v;
            long newRowId;
            newRowId = db.insert(TABLA_NOMBRE, null,values);
            db.close();
            setIndex((int) newRowId);
            dataObtener();
            return (int) newRowId;
        }

        public Boolean dataObtener(){
            return this.dataObtener(0);
        }
        public Boolean dataObtener(int lid){
            if(lid==0)
                lid=Index.getInt(0);
            Boolean v=false;

            SQLiteDatabase db = this.getReadableDatabase();

            cursor = db.query(TABLA_NOMBRE,
                    COLUMNAS,
                    " _id = ?",
                    new String[] { String.valueOf(lid) },
                    null,
                    null,
                    null,
                    null);
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    v = true;
                }
            } else {
                v=false;
            }
            db.close();
            return v;

        }
        //------------------------------------
        public void dataGrabar (int id,ContentValues v){
            SQLiteDatabase db = this.getWritableDatabase();
            ContentValues values = v;
            int i = db.update(TABLA_NOMBRE,
                    values,
                    " _id = ?",
                    new String[] { String.valueOf( id ) });
            db.close();
        }
        //======================================
        public boolean dataEliminar() {
            return this.dataEliminar(0);
        }
        public boolean dataEliminar(int id) {
            if(id==0)
                id=Index.getInt(0);
            SQLiteDatabase db = this.getWritableDatabase();
            try{
                db.delete(TABLA_NOMBRE,
                        " _id = ?",
                        new String[] { String.valueOf(id) });
                db.close();
                IndexUbicar(id);
                this.moverAnterior();
                int nid=Index.getInt(0);
                setIndex(nid);
                return true;

            }catch(Exception ex){
                return false;
            }
        }

        public String getValor(int c){
            return cursor.getString(c);
        }

        public int getValue(int c){
            return cursor.getInt(c);
        }

        protected Boolean setIndex(){
            return setIndex(0);
        }
        protected Boolean setIndex(int lid){
            Boolean v=false;
            SQLiteDatabase db = this.getReadableDatabase();
            String[] projection = {COLUMNA_ID};
            Index =
                    db.query(TABLA_NOMBRE,
                            projection,
                            null,
                            null,
                            null,
                            null,
                            null,
                            null);
            if (Index != null) {
                if(lid>0){
                    v=IndexUbicar(lid);
                }else{
                    if (Index.moveToFirst())
                        v=true;
                }
            } else {
                v=false;
            }
            db.close();
            return v;
        }
        private Boolean IndexUbicar(int lid){
            Boolean v=false;
            Index.moveToFirst();
            while(!Index.isAfterLast() && !v) {
                if(lid==Index.getInt(0)){
                    v=true;
                } else {
                    Index.moveToNext();
                }
            }
            return v;
        }
        public int moverPrimero(){
            Index.moveToFirst();
            this.dataObtener(Index.getInt(0));
            return Index.getInt(0);
        }
        public int moverAnterior(){
            if(!Index.isFirst())
                Index.moveToPrevious();
            else
                Index.moveToFirst();
            this.dataObtener(Index.getInt(0));
            return Index.getInt(0);
        }
        public int moverSiguiente(){
            if(!Index.isLast())
                Index.moveToNext();
            else
                Index.moveToLast();
            this.dataObtener(Index.getInt(0));
            return Index.getInt(0);
        }
        public int moverUltimo(){
            Index.moveToLast();
            this.dataObtener(Index.getInt(0));
            return Index.getInt(0);
        }
    //---------------------------------
        public Cursor dataBuscar(String where){
            Cursor c = null;
            SQLiteDatabase db = this.getReadableDatabase();

            c = db.query(TABLA_NOMBRE,
                    COLUMNAS,
                    where,
                    null,
                    null,
                    null,
                    null,
                    null);
            if (c != null) {
                c.moveToFirst();
            }
            db.close();
            return c;
        }
    //---------------------------------

    }